<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Work extends Model 
{

    protected $table = 'works';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'short_desc_ar', 'short_desc_en', 'desc_ar', 'desc_en', 'image', 'category_id');
    protected $visible = array('name_ar', 'name_en', 'short_desc_ar', 'short_desc_en', 'desc_ar', 'desc_en', 'image', 'category_id');

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }

}